# SENTINEL-X Safari Extension

Extension Safari pour la protection anti-hameçonnage en temps réel.

## 🛡️ Fonctionnalités

- **Vérification automatique** des sites visités
- **Détection des numéros frauduleux** sur les pages web
- **Alertes visuelles** pour les sites dangereux
- **Signalement rapide** des fraudes
- **Menu contextuel** pour vérifier une sélection
- **Synchronisation** avec la base SENTINEL-X

## 📦 Installation

### Méthode 1 : Build depuis les sources

1. Ouvrez Terminal
2. Naviguez vers le dossier safari :
   ```bash
   cd /chemin/vers/SENTINEL-X/safari
   ```
3. Exécutez le script de build :
   ```bash
   chmod +x build-safari.sh
   ./build-safari.sh
   ```
4. Ouvrez le projet Xcode généré
5. Sélectionnez votre équipe de développement
6. Build & Run

### Méthode 2 : Installation manuelle (développement)

1. Ouvrez Safari
2. Allez dans Safari > Préférences > Avancées
3. Cochez "Afficher le menu Développement"
4. Dans le menu Développement > Autoriser les extensions non signées
5. Convertissez l'extension avec :
   ```bash
   xcrun safari-web-extension-converter ./safari --project-location ./safari-xcode
   ```

## 🔧 Configuration requise

- macOS 11.0+ (Big Sur) ou iOS 15+
- Safari 14+
- Xcode 12+ (pour le build)

## 📱 Compatibilité

- ✅ macOS Safari
- ✅ iOS Safari
- ✅ iPadOS Safari

## 🔗 API

L'extension communique avec l'API SENTINEL-X :
- Base URL : `https://sentinel-x.mca-info.fr/api/v1`
- Endpoints utilisés :
  - `/fraud/check/phone/{phone}` - Vérification numéro
  - `/fraud/check/url` - Vérification URL
  - `/fraud/report` - Signalement
  - `/stats` - Statistiques

## 📄 Licence

© 2026 MCA INFO - Mélanie CARA
Tous droits réservés.

## 📞 Support

- Site : https://sentinel-x.mca-info.fr
- Email : support@mca-info.fr
