#!/bin/bash
# SENTINEL-X Safari Extension - Script de build
# MCA INFO - Génère le projet Xcode pour l'extension Safari

echo "🛡️ SENTINEL-X Safari Extension Builder"
echo "========================================"

# Répertoire de l'extension
EXT_DIR="$(dirname "$0")"
OUTPUT_DIR="$EXT_DIR/../safari-xcode"

# Vérifier si l'outil de conversion existe
if ! command -v xcrun &> /dev/null; then
    echo "❌ Erreur: Xcode command line tools requis"
    echo "   Installez avec: xcode-select --install"
    exit 1
fi

echo "📁 Création du projet Xcode..."

# Convertir l'extension web en projet Safari
xcrun safari-web-extension-converter "$EXT_DIR" \
    --project-location "$OUTPUT_DIR" \
    --app-name "SENTINEL-X" \
    --bundle-identifier "fr.mca-info.sentinel-x.extension" \
    --swift \
    --force

if [ $? -eq 0 ]; then
    echo "✅ Projet Xcode créé avec succès!"
    echo "📍 Emplacement: $OUTPUT_DIR"
    echo ""
    echo "Prochaines étapes:"
    echo "1. Ouvrez le projet dans Xcode: open $OUTPUT_DIR/SENTINEL-X/SENTINEL-X.xcodeproj"
    echo "2. Sélectionnez votre équipe de développement"
    echo "3. Build & Run pour tester dans Safari"
    echo "4. Archive pour distribuer sur l'App Store"
else
    echo "❌ Erreur lors de la conversion"
    exit 1
fi
